import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;

import javax.swing.JFrame;

public class Main {
	static int XSZ = 15, YSZ = 15;

	static int step = 0;

	static int NL = 5;

	static int HTL = 50;

	static JFrame jframe = new JFrame() {
		public void JFrame() {
			this.setTitle("Freenet Demo");
		}

		@Override
		public void paint(Graphics g) {
			Graphics2D g2d = (Graphics2D) g;
			this.setBackground(Color.BLACK);
			drawGrid(g2d);
		}
	};

	static Node[] nodes = new Node[XSZ * YSZ];

	static Random rand;

	static LinkedList<Node> route = null;

	static int[] linkLenHist = null;

	static Thread cThread;

	static char lastKeyPressed;

	static HashSet<Node> highlightedNodes = new HashSet<Node>();

	static boolean highlightLinks = false;
	
	static String epsFile;

	public static void main(String[] args) {
		int seed = args.length > 0 ? Integer.parseInt(args[0]) : (int) (System.currentTimeMillis() % 10000);
		System.out.println("Using seed: " + seed);
		epsFile = args.length < 2 ? null : args[1];
		rand = new Random(seed);
		
		cThread = new Thread() {
			public void run() {
				Main.cThreadRun();
			}
		};
		cThread.start();
	}

	protected static char waitForKeyPress() {
		synchronized (cThread) {
			try {
				cThread.wait();
			} catch (InterruptedException e) {
			}
		}
		return lastKeyPressed;
	}

	public static void cThreadRun() {
		createKleinbergGrid();
		updateHist();
		createFrame();
		if (epsFile != null) {
			drawEps(1);
		}
		waitForKeyPress();
		Node node1 = nodes[0];
		Node node2 = nodes[XSZ * YSZ - 1];
		route = greedyRoute(node1, node2);//(nodes[0], nodes[XSZ * YSZ - 1]);
		if (epsFile != null) {
			drawEps(2);
		}
		jframe.repaint();
		waitForKeyPress();
		shuffleGrid();
		updateHist();
		route = null;
		jframe.repaint();
		waitForKeyPress();
		//highlightedNodes.add(nodes[0]);
		//highlightedNodes.add(nodes[XSZ * YSZ - 1]);
		//highlightedNodes.clear();
		route = greedyRoute(node1, node2);//(findNode(0,0), findNode(XSZ - 1,YSZ - 1));
		jframe.repaint();
		waitForKeyPress();
		route = null;
//		while (true) {
//			Node[] swN = findSwitch();
//			highlightedNodes.add(swN[0]);
//			highlightedNodes.add(swN[1]);
//			jframe.repaint();
//			char k = waitForKeyPress();
//			if (k != ' ') {
//				break;
//			}
//			doSwitch(swN[0], swN[1]);
//			updateHist();
//			jframe.repaint();
//			k = waitForKeyPress();
//			if (k != ' ') {
//				break;
//			}
//			highlightedNodes.clear();
//		}
		
		highlightedNodes.add(nodes[0]);
		jframe.repaint();
		waitForKeyPress();
		
		for (int x = 0; x < 10 * XSZ * YSZ; x++) {
			Node[] sw = findSwitch();
			doSwitch(sw[0], sw[1]);
			if (x % 10 == 0) { 
				updateHist();
				jframe.repaint();
			}
			try {
				Thread.sleep(20);
			} catch (InterruptedException e) {
			}
			double logSum = 0;
			for (Node n : nodes) {
				logSum += n.logSum(n.xPos, n.yPos);
			}
		}
		updateHist();
		jframe.repaint();
		waitForKeyPress();	
		highlightedNodes.clear();
		updateHist();
		jframe.repaint();
		waitForKeyPress();
		route = greedyRoute(node1,node2);//greedyRoute(findNode(0,0), findNode(XSZ - 1, YSZ - 1));

		jframe.repaint();
		waitForKeyPress();
	}

	public static void keyPress() {
		synchronized (cThread) {
			cThread.notify();
		}
	}

	protected static void createFrame() {
		jframe.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		jframe.addKeyListener(new KeyListener() {

			public void keyTyped(KeyEvent arg0) {
				lastKeyPressed = arg0.getKeyChar();
				keyPress();
			}

			public void keyPressed(KeyEvent arg0) {
			}

			public void keyReleased(KeyEvent arg0) {
			}
		});
		jframe.setSize(640, 480);
		jframe.setVisible(true);
	}
	
	protected static Node findNode(int x, int y) {
		for (Node n : nodes)
			if (n.xPos == x && n.yPos == y)
				return n;
		return null;
	}

	protected static void createKleinbergGrid() {

		for (int x = 0; x < XSZ; x++) {
			for (int y = 0; y < YSZ; y++) {
				Node n = new Node(x, y);
				nodes[x * YSZ + y] = n;

			}
		}
		for (Node n : nodes) {
			int xp, yp;
			for (int i = 0; i < NL; i++) {
				Node m;
				do {
					do {
						int s = (int) Math.floor(Math.pow(Math.min(XSZ, YSZ),
								rand.nextFloat()));
						int xs = rand.nextInt(s + 1);
						int ys = s - xs;
						int xd = 2 * rand.nextInt(2) - 1;
						int yd = 2 * rand.nextInt(2) - 1;

						xp = n.xPos + xd * xs;
						yp = n.yPos + yd * ys;
					} while (0 > xp || xp >= XSZ || 0 > yp || yp >= YSZ);

					m = nodes[xp * YSZ + yp];

				} while (n.isNeighbor(m));

				if (!(n.addNeighbor(m) && m.addNeighbor(n))) {
					System.err.println("COULDNT ADD NEIGHBOR!");
					System.exit(1);
				}

			}
		}
	}

	protected static void shuffleGrid() {
		for (Node n : nodes) {
			Node m = nodes[rand.nextInt(nodes.length)];
			int x = n.xPos;
			int y = n.yPos;
			n.xPos = m.xPos;
			n.yPos = m.yPos;
			m.xPos = x;
			m.yPos = y;
		}
	}

	protected static Node[] findSwitch() {
		double p;
		Node n, m;
		int st = 0;
		do {
			n = nodes[rand.nextInt(nodes.length)];
			m = nodes[rand.nextInt(nodes.length)];

			p = Math.exp(-2.0
					* (n.logSum(m.xPos, m.yPos) + m.logSum(n.xPos, n.yPos)
							- n.logSum(n.xPos, n.yPos) - m.logSum(m.xPos,
							m.yPos)));
			if (++st > 10000)
				return null;
		} while (rand.nextDouble() > p);
		return new Node[] { n, m };

	}
	
	public static void doSwitch(Node n, Node m) {
		int x = n.xPos;
		int y = n.yPos;
		n.xPos = m.xPos;
		n.yPos = m.yPos;
		m.xPos = x;
		m.yPos = y;
	}

	protected static void drawEps(int n) {
		//Graphics2D gr = new EpsGraphics2D();
		
	}
	
	protected static void drawGrid(Graphics2D g) {
		g.clearRect(0, 0, jframe.getWidth(), jframe.getHeight());
		for (int i = 0; i < nodes.length; i++) {
			nodes[i].draw(g, false);
		}
		for (Node n : highlightedNodes) {
			n.draw(g, true);
		}
		if (route != null) {
			g.setColor(Color.RED);
			g.setStroke(new BasicStroke(2f));
			Node p = null;
			for (Node c : route) {
				if (p != null) {
					g.drawLine(p.axPos(), p.ayPos(), c.axPos(), c.ayPos());
				}
				p = c;
			}
		}
		int maxHVal = 0;
		for (int x = 0; x < linkLenHist.length; x++) {
			if (maxHVal < linkLenHist[x])
				maxHVal = linkLenHist[x];
		}
		for (int x = 1; x < linkLenHist.length; x++) {
			float dist = 0.5f + (0.5f / (float) x);
			g.setColor(new Color(dist, dist, dist));
			g.fillRect(x * (jframe.getWidth() / linkLenHist.length), (jframe
					.getHeight() - (100 * linkLenHist[x]) / maxHVal), jframe
					.getWidth()
					/ linkLenHist.length, (100 * linkLenHist[x]) / maxHVal);
		}
	}

	protected static int distance(Node a, Node b) {
		return Math.abs(a.xPos - b.xPos) + Math.abs(a.yPos - b.yPos);
	}

	protected static void updateHist() {
		linkLenHist = new int[XSZ + YSZ];
		for (Node n : nodes) {
			if (n != null) {
				for (Node nn : n.links) {
					if (nn != null)
						linkLenHist[distance(n, nn)]++;
				}
			}
		}
	}

	protected static LinkedList<Node> greedyRoute(Node start, Node end) {
		Node current = start;
		LinkedList<Node> hist = new LinkedList<Node>();
		while (!current.equals(end) && hist.size() < HTL) {
			hist.addLast(current);
			int dist = Integer.MAX_VALUE;
			Node next = null;
			for (Node n : current.links) {

				if (n == null || hist.contains(n))
					continue;
				if (distance(n, end) < dist) {
					next = n;
					dist = distance(n, end);
				}
			}

			if (next == null)
				break;
			current = next;
		}
		hist.addLast(end);
		return hist;
	}

	static class Node {
		int xPos, yPos;

		float roXpos = rand.nextFloat() / 2 - 0.25f,
				roYpos = rand.nextFloat() / 2 - 0.25f;

		Node[] links = new Node[NL * 10];

		int nl = 0;

		// Node[] inLinks = new Node[NL * 50]; // this can never break!

		public Node(int pos, int pos2) {
			super();
			xPos = pos;
			yPos = pos2;
		}

		public int axPos() {
			return (int) ((xPos + roXpos + 1) * (jframe.getWidth() / (XSZ + 1)));
		}

		public int ayPos() {
			return (int) ((yPos + roYpos + 1) * ((jframe.getHeight() - 100) / (YSZ + 1)));
		}

		public boolean addNeighbor(Node n) {
			if (isNeighbor(n))
				return false;
			links[nl] = n;
			nl++;
			return true;
		}

		public boolean isNeighbor(Node n) {
			for (int i = 0; i < nl; i++) {
				if (links[i] == n)
					return true;
			}
			return false;
		}

		public double logSum(int x, int y) {
			double sum = 0;
			for (int i = 0; i < nl; i++) {
				Node n = links[i];
				if (n.xPos == x && n.yPos == y) {
					sum += Math.log(Math.abs(x - xPos) + Math.abs(y - yPos));
				} else {
					sum += Math
							.log(Math.abs(x - n.xPos) + Math.abs(y - n.yPos));
				}
			}
			return sum;
		}

		public void draw(Graphics2D g, boolean useHL) {
			boolean highlight = highlightedNodes.contains(this) && useHL;
				g.setColor(highlight ? Color.GREEN : Color.WHITE);
				if (highlight) {
					g.setStroke(new BasicStroke(2.5f));
				} else {
					g.setStroke(new BasicStroke(0.5f));
				}
			g.drawOval(axPos() - (highlight ? 4 : 2), ayPos()
					- (highlight ? 4 : 2), (highlight ? 8 : 4), (highlight ? 8
					: 4));
			for (Node link : links) {
				if (link != null) {
					float dist = 0.5f + (0.5f / (float) (distance(this, link)));
					g.setColor(highlight ? Color.GREEN : new Color(dist, dist, dist));
					g.drawLine(axPos(), ayPos(), link.axPos(), link.ayPos());
				}
			}
		}
	}
}
